//
//  TWTwitchStreamer.h
//  Twitch Streamer
//
//  Created by Auston Stewart on 11/7/13.
//  Copyright (c) 2014 Justin.tv, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreVideo/CoreVideo.h>

@interface TWTwitchStreamer : NSObject

+ (TWTwitchStreamer *)twitchStreamer;

- (void)submitAudioSamples;
- (void)prepareToStream;
- (void)stopStream;
- (void)restartStream;
- (void)shutdown:(BOOL)synchronous;
- (void)pause;
- (void)resume;
- (void)logout;
- (void)runCommercial;

@property (nonatomic,readonly) BOOL isStreaming;
@property (nonatomic,readonly) BOOL isPaused;

@end

extern NSString * const kTWTwitchStreamerFrameUnlockNotifcation;

